using System;
using Server;

namespace Xanthos.Evo
{
	public sealed class EvoSpiderSpec : BaseEvoSpec
	{
		// This class implements a singleton pattern; meaning that no matter how many times the
		// Instance attribute is used, there will only ever be one of these created in the entire system.
		// Copy this template and give it a new name.  Assign all of the data members of the EvoSpec
		// base class in the constructor.  Your subclass must not be abstract.
		// Never call new on this class, use the Instance attribute to get the instance instead.

		EvoSpiderSpec()
		{
			m_Tamable = true;
			m_MinTamingToHatch = 50.0;
			m_PercentFemaleChance = 0.02;	// Made small to limit access to eggs.
			m_GuardianEggOrDeedChance = 0.30;
			m_AlwaysHappy = true;
			m_ProducesYoung = true;
			m_PregnancyTerm = 0.10;
			m_AbsoluteStatValues = false;
			m_MaxEvoResistance = 100;
			m_MaxTrainingStage = 3;
			m_CanAttackPlayers = false;

			m_RandomHues = new int[] { 2101, 2102, 2103, 2104, 2105, 2106, 2107, 2108, 2109, 2110, 2111, 2112, 2113, 2114, 2115, 2116, 2117, 2118, 2119, 2120, 2121, 2122, 2123, 2124, 2125, 2126, 2127, 2128, 2129, 2130, 1281, 1283, 1285, 1378, 1369, 1266 };

			m_Skills = new SkillName[8] { SkillName.Anatomy, SkillName.Meditation, SkillName.MagicResist,
										  SkillName.Tactics, SkillName.Wrestling, SkillName.Poisoning, SkillName.AnimalLore, SkillName.Veterinary };
			m_MinSkillValues = new int[8] { 20, 20, 20, 20, 20, 30, 30, 30 };
			m_MaxSkillValues = new int[8] { 100, 100, 100, 100, 100, 120, 100, 100 };

			m_Stages = new BaseEvoStage[] { new EvoSpiderStageOne(), new EvoSpiderStageTwo(),
											  new EvoSpiderStageThree(), new EvoSpiderStageFour(),
											  new EvoSpiderStageFive(), new EvoSpiderStageSix(),
											  new EvoSpiderStageSeven() };
		}

		// These next 2 lines facilitate the singleton pattern.  In your subclass only change the
		// BaseEvoSpec class name to your subclass of BaseEvoSpec class name and uncomment both lines.
		public static EvoSpiderSpec Instance { get { return Nested.instance; } }
		class Nested { static Nested() { } internal static readonly EvoSpiderSpec instance = new EvoSpiderSpec();}
	}	

	// Define a subclass of BaseEvoStage for each stage in your creature and place them in the
	// array in your subclass of BaseEvoSpec.  See the example classes for how to do this.
	// Your subclass must not be abstract.

	public class EvoSpiderStageOne : BaseEvoStage
	{
		public EvoSpiderStageOne()
		{
			EvolutionMessage = "has evolved";
			NextEpThreshold = 25000; EpMinDivisor = 40; EpMaxDivisor = 30; DustMultiplier = 25;
			BaseSoundID = 0x388;
			BodyValue = 28; ControlSlots = 3; MinTameSkill = 50.0; VirtualArmor = 30;
			Hue = Evo.Flags.kRandomHueFlag;

			DamagesTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
													ResistanceType.Poison, ResistanceType.Energy };
			MinDamages = new int[5] { 30, 0, 0, 70, 0 };
			MaxDamages = new int[5] { 30, 0, 0, 70, 0 };

			ResistanceTypes = new ResistanceType[1] { ResistanceType.Poison };
			MinResistances = new int[1] { 20 };
			MaxResistances = new int[1] { 20 };

			DamageMin = 8; DamageMax = 13; HitsMin = 50; HitsMax = 60;
			StrMin = 50; StrMax = 60; DexMin = 56; DexMax = 75; IntMin = 80; IntMax = 90;
		}
	}

	public class EvoSpiderStageTwo : BaseEvoStage
	{
		public EvoSpiderStageTwo()
		{
			EvolutionMessage = "has evolved";
			NextEpThreshold = 75000; EpMinDivisor = 100; EpMaxDivisor = 80; DustMultiplier = 25;
			BaseSoundID = 0x388; MinTameSkill = 60.0;
			BodyValue = 28; VirtualArmor = 40;
		
			DamagesTypes = null;
			MinDamages = null;
			MaxDamages = null;

			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 20, 20, 20, 40, 20 };
			MaxResistances = new int[5] { 20, 20, 20, 40, 20 };

			DamageMin = 1; DamageMax = 1; HitsMin= 50; HitsMax = 60;
			StrMin = 50; StrMax = 60; DexMin = 20; DexMax = 20; IntMin = 0; IntMax = 0;
		}
	}

	public class EvoSpiderStageThree : BaseEvoStage
	{
		public EvoSpiderStageThree()
		{
			EvolutionMessage = "has evolved";
			NextEpThreshold = 175000; EpMinDivisor = 500; EpMaxDivisor = 300; DustMultiplier = 25;
			BaseSoundID = 0x388; MinTameSkill = 70.0;
			BodyValue = 28; VirtualArmor = 50;
		
			DamagesTypes = null;
			MinDamages = null;
			MaxDamages = null;

			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 40, 40, 40, 60, 40 };
			MaxResistances = new int[5] { 40, 40, 40, 60, 40 };

			DamageMin = 1; DamageMax = 1; HitsMin= 50; HitsMax = 60;
			StrMin = 50; StrMax = 60; DexMin = 10; DexMax = 10; IntMin = 0; IntMax = 0;
		}
	}

	public class EvoSpiderStageFour : BaseEvoStage
	{
		public EvoSpiderStageFour()
		{
			EvolutionMessage = "has evolved";
			NextEpThreshold = 3750000; EpMinDivisor = 600; EpMaxDivisor = 450; DustMultiplier = 25;
			BaseSoundID = 0x388;
			BodyValue = 28; MinTameSkill = 80.0; VirtualArmor = 60;
		
			DamagesTypes = null;
			MinDamages = null;
			MaxDamages = null;

			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 50, 50, 50, 80, 50 };
			MaxResistances = new int[5] { 50, 50, 50, 80, 50 };	

			DamageMin = 1; DamageMax = 1; HitsMin= 50; HitsMax = 60;
			StrMin = 50; StrMax = 60; DexMin = 10; DexMax = 10; IntMin = 0; IntMax = 0;
		}
	}

	public class EvoSpiderStageFive : BaseEvoStage
	{
		public EvoSpiderStageFive()
		{
			EvolutionMessage = "has evolved";
			NextEpThreshold = 7750000; EpMinDivisor = 1000; EpMaxDivisor = 700; DustMultiplier = 25;
			BodyValue = 11; BaseSoundID = 1170; VirtualArmor = 70; MinTameSkill = 90.0; ControlSlots = 4;
		
			DamagesTypes = null;
			MinDamages = null;
			MaxDamages = null;

			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 60, 60, 60, 90, 60 };
			MaxResistances = new int[5] { 60, 60, 60, 90, 60 };	

			DamageMin = 2; DamageMax = 2; HitsMin= 150; HitsMax = 150;
			StrMin = 100; StrMax = 100; DexMin = 20; DexMax = 20; IntMin = 0; IntMax = 0;
		}
	}

	public class EvoSpiderStageSix : BaseEvoStage
	{
		public EvoSpiderStageSix()
		{
			EvolutionMessage = "has evolved";
			NextEpThreshold = 15000000; EpMinDivisor = 2000; EpMaxDivisor = 1000; DustMultiplier = 25;
			BodyValue = 11; BaseSoundID = 1170; VirtualArmor = 170; MinTameSkill = 100.0;
		
			DamagesTypes = null;
			MinDamages = null;
			MaxDamages = null;

			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 70, 70, 70, 100, 70 };
			MaxResistances = new int[5] { 70, 70, 70, 100, 70 };	

			DamageMin = 2; DamageMax = 2; HitsMin= 150; HitsMax = 150;
			StrMin = 100; StrMax = 100; DexMin = 20; DexMax = 20; IntMin = 0; IntMax = 0;
		}
	}

	public class EvoSpiderStageSeven : BaseEvoStage
	{
		public EvoSpiderStageSeven()
		{
			Title = "the Mirror Spider";
			EvolutionMessage = "has evolved to its highest form and is now an Ancient Mirror Spider";
			NextEpThreshold = 0; EpMinDivisor = 150000; EpMaxDivisor = 100000; DustMultiplier = 25;
			BaseSoundID = 0x183; MinTameSkill = 105.0;
			BodyValue = 173; ControlSlots = 4; VirtualArmor = 270;
		
			DamagesTypes = null;
			MinDamages = null;
			MaxDamages = null;

			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 80, 80, 80, 100, 80 };
			MaxResistances = new int[5] { 80, 80, 80, 100, 80 };	

			DamageMin = 6; DamageMax = 7; HitsMin= 550; HitsMax = 550;
			StrMin = 125; StrMax = 125; DexMin = 25; DexMax = 35; IntMin = 125; IntMax = 125;
		}
	}
}